/*
 * Decompiled with CFR 0.152.
 */
package jclass.image;

class ByteString
implements Cloneable {
    private byte[] contents;
    private int size;
    private static final int factor = 5;

    public ByteString() {
        this.contents = null;
        this.size = 0;
    }

    public ByteString(byte by) {
        this.contents = new byte[5];
        this.contents[0] = by;
        this.size = 1;
    }

    public ByteString(byte[] byArray) {
        if (byArray == null) {
            this.contents = new byte[5];
            this.size = 0;
            return;
        }
        this.contents = new byte[(byArray.length / 5 + 1) * 5];
        this.size = byArray.length;
        System.arraycopy(byArray, 0, this.contents, 0, byArray.length);
    }

    public ByteString(ByteString byteString) {
        if (byteString == null || byteString.contents == null) {
            this.contents = null;
            this.size = 0;
            return;
        }
        this.contents = new byte[byteString.contents.length];
        System.arraycopy(byteString.contents, 0, this.contents, 0, this.contents.length);
        this.size = byteString.size;
    }

    protected Object clone() {
        ByteString byteString = new ByteString(this.contents);
        return byteString;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.contents == null || this.size == 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            if (this.contents == byteString.contents) {
                return true;
            }
            if (byteString.size == this.size) {
                int n = 0;
                while (n < this.size) {
                    if (byteString.contents[n] != this.contents[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.contents == byArray) {
                return true;
            }
            if (byArray.length == this.size) {
                int n = 0;
                while (n < this.size) {
                    if (byArray[n] != this.contents[n]) break;
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public ByteString append(byte by) {
        if (this.contents == null) {
            this.contents = new byte[5];
            this.contents[0] = by;
            this.size = 1;
        } else if (this.size == this.contents.length) {
            byte[] byArray = new byte[this.contents.length + 5];
            System.arraycopy(this.contents, 0, byArray, 0, this.contents.length);
            byArray[this.contents.length] = by;
            this.contents = byArray;
            ++this.size;
        } else {
            this.contents[this.size] = by;
            ++this.size;
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contents == null) {
            return "(null)";
        }
        int n = 0;
        while (n < this.size) {
            String string = Integer.toString(this.contents[n], 16);
            if (string.length() == 1) {
                stringBuffer.append('0');
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte byteAt(int n) {
        if (n < this.size) {
            return this.contents[n];
        }
        throw new IndexOutOfBoundsException("index " + n + " out of bounds");
    }

    public int length() {
        if (this.contents == null) {
            return 0;
        }
        return this.size;
    }

    public ByteString suffix() {
        ByteString byteString = new ByteString();
        if (this.contents != null && this.contents.length != 0 && this.contents.length != 1) {
            byteString.contents = new byte[this.contents.length];
            byteString.size = this.size - 1;
            System.arraycopy(this.contents, 1, byteString.contents, 0, byteString.size);
        }
        return byteString;
    }
}

